<?php
// sign-up.php

// Include the database connection file
require_once 'db_connect.php'; // Adjust path if db_connect.php is elsewhere

// Set the response header to JSON
header('Content-Type: application/json');

// --- Initialize the default response structure ---
$response = [
    "data" => [
        "success" => false // Default to false
    ]
];

// --- Get and Validate URL Parameters ---
if (!isset($_GET['name']) || !isset($_GET['phone'])) {
    // If required parameters are missing
    echo json_encode($response);
    if (isset($conn) && $conn instanceof mysqli) { mysqli_close($conn); }
    exit();
}

$name = trim($_GET['name']);
$phone_raw = trim($_GET['phone']);

// Basic validation
if (empty($name) || empty($phone_raw)) {
    // If name or phone is empty after trimming
    echo json_encode($response);
    if (isset($conn) && $conn instanceof mysqli) { mysqli_close($conn); }
    exit();
}

// --- Normalize Phone Number ---
// Remove common non-digit characters except leading '+'
$phone_normalized = preg_replace('/[^\d+]/', '', $phone_raw);
// Ensure it starts with '+' (assuming this is your standard storage format)
if (substr($phone_normalized, 0, 1) !== '+') {
    // Attempt to prepend '+' - this might need adjustment based on expected input formats
    // A more robust library (like libphonenumber) is recommended for real-world validation/normalization
    $phone_normalized = '+' . $phone_normalized;
}

// --- Check if Phone Number Already Exists ---
$sql_check = "SELECT user_id FROM users WHERE phone_number = ? LIMIT 1";
$stmt_check = mysqli_prepare($conn, $sql_check);
$user_exists = false;

if ($stmt_check) {
    mysqli_stmt_bind_param($stmt_check, "s", $phone_normalized);
    if (mysqli_stmt_execute($stmt_check)) {
        mysqli_stmt_store_result($stmt_check);
        if (mysqli_stmt_num_rows($stmt_check) > 0) {
            $user_exists = true;
        }
    } else {
         // Log error execution
         // error_log("Signup Check Query Execute Failed: " . mysqli_stmt_error($stmt_check));
    }
    mysqli_stmt_close($stmt_check);
} else {
    // Log error prepare
    // error_log("Signup Check Query Prepare Failed: " . mysqli_error($conn));
}

// If user already exists, return failure and exit
if ($user_exists) {
    // Optionally add a specific error message here for debugging if needed
    // $response['error'] = "Phone number already registered.";
    echo json_encode($response);
    mysqli_close($conn);
    exit();
}


// --- Prepare for Insert (User does not exist) ---

// !!! SECURITY WARNING: Using a placeholder password is NOT secure !!!
// In a real application, you MUST get a password from the user or use OTP/passwordless flow.
define('PLACEHOLDER_PASSWORD', 'temporaryDefaultPassword123!'); // CHANGE THIS IN A REAL APP
$password_hash = password_hash(PLACEHOLDER_PASSWORD, PASSWORD_DEFAULT);

if ($password_hash === false) {
    // Password hashing failed - Log error
    // error_log("Password hashing failed.");
    echo json_encode($response);
    mysqli_close($conn);
    exit();
}


// --- Insert New User ---
$sql_insert = "INSERT INTO users (full_name, phone_number, password_hash, is_verified) VALUES (?, ?, ?, ?)";
// Note: Setting is_verified to FALSE by default as per schema. Adjust if needed.
$is_verified_default = false;

$stmt_insert = mysqli_prepare($conn, $sql_insert);

if ($stmt_insert) {
    // Bind parameters: string, string, string, integer (for boolean false=0)
    mysqli_stmt_bind_param($stmt_insert, "sssi", $name, $phone_normalized, $password_hash, $is_verified_default);

    // Execute the insert statement
    if (mysqli_stmt_execute($stmt_insert)) {
        // Check if exactly one row was inserted
        if (mysqli_stmt_affected_rows($stmt_insert) === 1) {
            // Success! Update the response
            $response['data']['success'] = true;
        }
        // Else: Insertion failed (affected_rows != 1), success remains false
    } else {
        // Insert execution failed - Log error
        // error_log("Signup Insert Query Execute Failed: " . mysqli_stmt_error($stmt_insert));
        // success remains false
    }
    mysqli_stmt_close($stmt_insert);

} else {
    // Insert prepare failed - Log error
    // error_log("Signup Insert Query Prepare Failed: " . mysqli_error($conn));
    // success remains false
}

// --- Close Database Connection ---
mysqli_close($conn);

// --- Output the final JSON response ---
echo json_encode($response);

?>