<?php
// db_connect.php

// --- Database Credentials ---
// IMPORTANT: In a real production environment, use environment variables
// or a configuration file outside the web root for sensitive data.
define('DB_SERVER', 'localhost'); // Usually 'localhost' if the DB is on the same server
define('DB_USERNAME', 'XXXXXXXX');
define('DB_PASSWORD', 'XXXXXXXX'); // Use the correct password you were given
define('DB_NAME', 'XXXXXXXX');

// --- Establish Connection ---
$conn = mysqli_connect(DB_SERVER, DB_USERNAME, DB_PASSWORD, DB_NAME);

// --- Check Connection ---
if ($conn === false) {
    // In a real app, log this error securely instead of echoing directly
    // For development, die() is okay to see the error immediately.
    header('Content-Type: application/json');
    http_response_code(500); // Internal Server Error
    echo json_encode([
        "error" => "Database connection failed",
        "details" => mysqli_connect_error() // Be cautious exposing detailed errors in production
    ]);
    exit(); // Stop script execution
}

// --- Set Character Set ---
// Good practice to ensure proper encoding, especially with names/text
if (!mysqli_set_charset($conn, "utf8mb4")) {
    // Log error if needed
    // printf("Error loading character set utf8mb4: %s\n", mysqli_error($conn));
}

// The $conn variable is now available for use in scripts that include this file.
?>