<?php
// list_job_categories.php

// Include the database connection file
require_once 'db_connect.php'; // Adjust path if db_connect.php is elsewhere

// Set the response header to JSON
header('Content-Type: application/json');

// --- Define the basic structure of the response ---
// This mirrors the example JSON you provided.
$response = [
    "data" => [
        "interactive" => [
            "type" => "list",
            "body" => [
                // You can customize this text
                "text" => "Please choose a job category from the options below."
            ],
            "action" => [
                // You can customize this button text
                "button" => "Select Category",
                "sections" => [
                    [
                        // You can customize this section title
                        "title" => "Available Job Categories",
                        "rows" => [] // Initialize rows as an empty array
                    ]
                ]
            ]
        ]
    ]
];

// --- Fetch Job Categories from Database ---
$sql = "SELECT category_id, name FROM job_categories ORDER BY name ASC"; // Get ID and Name, order alphabetically

$stmt = mysqli_prepare($conn, $sql);

$categories_found = false;

if ($stmt) {
    // Execute the statement
    if (mysqli_stmt_execute($stmt)) {
        // Get the result
        $result = mysqli_stmt_get_result($stmt);

        // Check if categories were found
        if (mysqli_num_rows($result) > 0) {
            $categories_found = true;
            // Loop through each category and format it for the response
            while ($category = mysqli_fetch_assoc($result)) {
                // Create the row structure required by the JSON format
                $row_item = [
                    // Important: Ensure the ID is a string if the receiving system expects it
                    "id" => (string)$category['category_id'],
                    "title" => $category['name']
                    // Add description if needed and supported by the interactive format
                    // "description" => $category['description'] ?? ''
                ];

                // Add the formatted row to the 'rows' array in our response structure
                $response['data']['interactive']['action']['sections'][0]['rows'][] = $row_item;
            }
        }
        // Else: No categories found, the 'rows' array will remain empty, which is valid JSON.

    } else {
        // SQL execution failed - Log this error in a real application
        // error_log("Error executing statement: " . mysqli_stmt_error($stmt));
        // Optionally modify response to indicate an error, but often returning
        // an empty list or default structure is preferred for client stability.
    }

    // Close the statement
    mysqli_stmt_close($stmt);

} else {
    // SQL preparation failed - Log this error in a real application
    // error_log("Error preparing statement: " . mysqli_error($conn));
}

// --- Close Database Connection ---
mysqli_close($conn);

// --- Output the final JSON response ---
// Use JSON_PRETTY_PRINT for easier reading during development (optional)
echo json_encode($response, JSON_PRETTY_PRINT);

?>