<?php
// jobs_listing_count.php

// Include the database connection file
require_once 'db_connect.php'; // Adjust path if db_connect.php is elsewhere

// Set the response header to JSON
header('Content-Type: application/json');

// --- Initialize the default response structure ---
$response = [
    "data" => [
        "success" => false // Default to false
    ]
];

// --- Get and Validate URL Parameter ---
$category_id = null;
if (isset($_GET['category']) && is_numeric($_GET['category'])) {
    $category_id = (int)$_GET['category'];
} else {
    // If category is missing or invalid, return the default failure response
    echo json_encode($response);
    if (isset($conn) && $conn) { // Check if $conn was successfully initialized in db_connect.php
       mysqli_close($conn);
    }
    exit();
}

// --- Check for Active Jobs in the Category ---

// Use SELECT 1 ... LIMIT 1 for efficiency, as we only need to know if *any* row exists.
$sql = "SELECT 1 FROM jobs WHERE category_id = ? AND is_active = TRUE LIMIT 1";

$stmt = mysqli_prepare($conn, $sql);

if ($stmt) {
    // Bind the category_id parameter (integer)
    mysqli_stmt_bind_param($stmt, "i", $category_id);

    // Execute the statement
    if (mysqli_stmt_execute($stmt)) {
        // Store the result (needed to check the number of rows)
        mysqli_stmt_store_result($stmt);

        // Check if any row was returned (mysqli_stmt_num_rows > 0 means at least one active job exists)
        if (mysqli_stmt_num_rows($stmt) > 0) {
            // Job(s) found, set success to true
            $response['data']['success'] = true;
        }
        // Else: No rows found, success remains false (the default)

    } else {
        // SQL execution failed - Log this error in a real application
        // error_log("Jobs Count Query Execution Failed: " . mysqli_stmt_error($stmt));
        // Keep response as default failure
    }

    // Close the statement
    mysqli_stmt_close($stmt);

} else {
    // SQL preparation failed - Log this error in a real application
    // error_log("Jobs Count Query Prepare Failed: " . mysqli_error($conn));
    // Keep response as default failure
}

// --- Close Database Connection ---
mysqli_close($conn);

// --- Output the final JSON response ---
echo json_encode($response);

?>